/******************************************************************************
*                                                                             *
* Freescale Semiconductor Inc.                                                *
* (c) Copyright 2004-2007 Freescale Semiconductor, Inc.                       *
* ALL RIGHTS RESERVED.                                                        *
*                                                                             *
*******************************************************************************
*******************************************************************************
* Definitions for S08QE8  - I2C Slave + IR decoder + GPIO port;              *
*                           I2C max speed 100kHz;                             *
*                           IR - RC-5 frame;                                  *
******************************************************************************/

#ifndef _APPLICATION_H
#define _APPLICATION_H

/*-----------------------------------------------------------------------------

    MCU pins final connection:

    pin 7 - PTB5 / IR Receiver - input;
    pin 5 - PTB7 / PWR_Control - output;
    pin 3 = Vdd  / +1.8V to 3.3V
    pin 4 = Vss  / GND
    pin 16 - PTA0 / GPIO_RF
    pin 15 - PTA1 / STBY Button
    pin 13 - PTA3 / SCL - I2C
    pin 14 - PTA2 / SDA - I2C

-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
/* Definitions */

#define RC5_PIN         PTBD_PTBD0
#define PWR_PIN         PTBD_PTBD7          // Power Pin Control;
#define BUTTON          PTAD_PTAD1
#define GPIO_MASK       KBIPE_KBIPE5_MASK

#define DBG_PIN         PTBD_PTBD4

//------------------------------------------
#define MY_I2C_ADDR     0xA0        // my own IIC slave address;

#define OFF             1           // for Power Pin Control;
#define ON              0           // for Power Pin Control;
#define RUN             1
#define SLEEP           0
#define RC5             5
#define STBY            6
#define I2C             9

//----- Macro for Vectors recognition ------
#define IV(x) ((0xFFFE-(x))/2)

//-----------------------------------------------------------------------------
/* IR Address and Command table */

enum
{
    ADDR1 = 0,
    ADDR2 = 1,
    ADDR3 = 3,
    ADDR4 = 5,
    ADDR5 = 6,
    ADDR6 = 8,
    ADDR7 = 0xA,
    ADDR8 = 0xC,
    ADDR9 = 0x11,
    ADDR10 = 0x14,
    ADDR11 = 0x16,
    ADDR12 = 0x1A
} valid_Address;

enum
{
    CMD_ON1 = 0,
    CMD_ON2 = 1,
    CMD_ON3 = 2,
    CMD_ON4 = 3,
    CMD_ON5 = 4,
    CMD_ON6 = 5,
    CMD_ON7 = 6,
    CMD_ON8 = 7,
    CMD_ON9 = 8,
    CMD_ON10 = 9,
    CMD_ON11 = 0x35
} valid_CommamdON;

enum
{
    CMD_OFF1 = 0x0C
} valid_CommamdOFF;

//-----------------------------------------------------------------------------
/* Global variables */

#pragma DATA_SEG SHORT MY_ZEROPAGE

volatile byte mode, Address, Command, flag, i2c_cnt, temp;
volatile byte r_w, RX_data, TX_data, IR_data;
volatile byte address_valid, command_ON, command_OFF;

#pragma DATA_SEG DEFAULT 

//-----------------------------------------------------------------------------
/* Function declarations */
void MCU_init(void); /* Device initialization function declaration */
void Init_Variables(void);
void IR_receive(void);
void STBY_Button(void);
void Delay(word del);
void Wait1ms(void);
void WaitNms(byte del);
void Compare_IR(void);
void Compare_I2C(void);

//-----------------------------------------------------------------------------
#endif /* _APPLICATION_H */
